/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation.defaults;

import com.ldtteam.datagenerators.loot_table.LootTableJson;
import com.ldtteam.datagenerators.loot_table.pool.entry.EntryTypeEnum;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.coremod.generation.CustomRecipeProvider;
import com.minecolonies.coremod.generation.LootTableBuilder;
import com.minecolonies.coremod.generation.LootTableJsonProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DefaultSifterCraftingProvider
implements IDataProvider {
    private final SifterRecipeProvider recipeProvider;
    private final SifterLootTableProvider lootTableProvider;
    private final Map<Item, List<SifterMeshDetails>> inputs = new HashMap<Item, List<SifterMeshDetails>>();

    public DefaultSifterCraftingProvider(@NotNull DataGenerator generatorIn) {
        this.inputs.put(Items.field_221582_j, Stream.of(new SifterMeshDetails(ModItems.sifterMeshString, 1, new LootTableBuilder().empty(71).item(Items.field_151014_N, 25).item(Items.field_221592_t, 1).item(Items.field_221594_v, 1).item(Items.field_221593_u, 1).item(Items.field_221595_w, 1).build()), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, new LootTableBuilder().empty(28).item(Items.field_151014_N, 50).item(Items.field_221592_t, 5).item(Items.field_221594_v, 5).item(Items.field_221593_u, 5).item(Items.field_221595_w, 5).item(Items.field_151172_bF, 1).item(Items.field_151174_bG, 1).build()), new SifterMeshDetails(ModItems.sifterMeshIron, 4, new LootTableBuilder().bonusRolls(0.025f).empty(3).item(Items.field_151014_N, 50).item(Items.field_221592_t, 10).item(Items.field_221594_v, 10).item(Items.field_221593_u, 10).item(Items.field_221595_w, 10).item(Items.field_151172_bF, 1).item(Items.field_151174_bG, 1).item(Items.field_151080_bb, 1).item(Items.field_151081_bc, 1).item(Items.field_185163_cU, 1).item(Items.field_221597_y, 1).item(Items.field_221596_x, 1).build()), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, new LootTableBuilder().bonusRolls(0.035f).empty(5).item(Items.field_151014_N, 25).item(Items.field_221592_t, 10).item(Items.field_221594_v, 10).item(Items.field_221593_u, 10).item(Items.field_221595_w, 10).item(Items.field_151172_bF, 5).item(Items.field_151174_bG, 5).item(Items.field_151080_bb, 5).item(Items.field_151081_bc, 5).item(Items.field_185163_cU, 5).item(Items.field_221597_y, 5).item(Items.field_221596_x, 5).build())).collect(Collectors.toList()));
        this.inputs.put(Items.field_221550_C, Stream.of(new SifterMeshDetails(ModItems.sifterMeshString, 1, new LootTableBuilder().empty(85).item(Items.field_191525_da, 5).item(Items.field_151145_ak, 5).item(Items.field_151044_h, 5).build()), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, new LootTableBuilder().empty(60).item(Items.field_191525_da, 10).item(Items.field_151145_ak, 10).item(Items.field_151044_h, 10).item(Items.field_151137_ax, 10).build()), new SifterMeshDetails(ModItems.sifterMeshIron, 4, new LootTableBuilder().bonusRolls(0.025f).empty(46).item(Items.field_151137_ax, 15).item(Items.field_191525_da, 15).item(Items.field_151044_h, 15).item(Items.field_196128_bn, 5).item(Items.field_151042_j, 1).item(Items.field_151043_k, 1).item(Items.field_151166_bC, 1).item(Items.field_151045_i, 1).build()), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, new LootTableBuilder().bonusRolls(0.035f).empty(40).item(Items.field_151137_ax, 20).item(Items.field_191525_da, 20).item(Items.field_151044_h, 20).item(Items.field_196128_bn, 10).item(Items.field_151042_j, 2).item(Items.field_151043_k, 2).item(Items.field_151166_bC, 2).item(Items.field_151045_i, 2).build())).collect(Collectors.toList()));
        this.inputs.put(Items.field_221548_A, Stream.of(new SifterMeshDetails(ModItems.sifterMeshString, 1, new LootTableBuilder().empty(95).item(Items.field_221774_cw, 2).item(Items.field_222065_kN, 2).build()), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, new LootTableBuilder().empty(85).item(Items.field_221774_cw, 5).item(Items.field_222065_kN, 5).item(Items.field_151074_bl, 5).build()), new SifterMeshDetails(ModItems.sifterMeshIron, 4, new LootTableBuilder().bonusRolls(0.025f).empty(60).item(Items.field_221774_cw, 10).item(Items.field_222065_kN, 10).item(Items.field_151074_bl, 10).item(Items.field_196130_bo, 10).build()), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, new LootTableBuilder().bonusRolls(0.035f).empty(40).item(Items.field_221774_cw, 15).item(Items.field_222065_kN, 15).item(Items.field_151074_bl, 15).item(Items.field_196130_bo, 15).build())).collect(Collectors.toList()));
        this.inputs.put(Items.field_221693_cI, Stream.of(new SifterMeshDetails(ModItems.sifterMeshString, 1, new LootTableBuilder().empty(90).item(Items.field_151075_bm, 5).item(Items.field_151128_bU, 5).build()), new SifterMeshDetails(ModItems.sifterMeshFlint, 3, new LootTableBuilder().empty(70).item(Items.field_151075_bm, 10).item(Items.field_151128_bU, 10).item(Items.field_151114_aO, 10).build()), new SifterMeshDetails(ModItems.sifterMeshIron, 4, new LootTableBuilder().bonusRolls(0.025f).empty(50).item(Items.field_151075_bm, 10).item(Items.field_151128_bU, 10).item(Items.field_151114_aO, 10).item(Items.field_151065_br, 1).item(Items.field_151064_bs, 1).build()), new SifterMeshDetails(ModItems.sifterMeshDiamond, 5, new LootTableBuilder().bonusRolls(0.035f).empty(40).item(Items.field_151075_bm, 15).item(Items.field_151128_bU, 15).item(Items.field_151114_aO, 15).item(Items.field_151065_br, 5).item(Items.field_151064_bs, 5).item(Items.field_196184_dx, 5).build())).collect(Collectors.toList()));
        this.recipeProvider = new SifterRecipeProvider(generatorIn);
        this.lootTableProvider = new SifterLootTableProvider(generatorIn);
    }

    @NotNull
    public String func_200397_b() {
        return "SifterCraftingProvider";
    }

    public void func_200398_a(@NotNull DirectoryCache cache) throws IOException {
        this.recipeProvider.func_200398_a(cache);
        this.lootTableProvider.func_200398_a(cache);
    }

    private class SifterLootTableProvider
    extends LootTableJsonProvider {
        public SifterLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @Override
        protected Map<ResourceLocation, LootTableJson> getLootTables() {
            HashMap<ResourceLocation, LootTableJson> tables = new HashMap<ResourceLocation, LootTableJson>();
            for (Map.Entry inputEntry : DefaultSifterCraftingProvider.this.inputs.entrySet()) {
                for (SifterMeshDetails mesh : (List)inputEntry.getValue()) {
                    String name = mesh.getName() + "/" + ((Item)inputEntry.getKey()).getRegistryName().func_110623_a();
                    tables.put(new ResourceLocation("minecolonies", "recipes/" + name), mesh.getLootTable());
                }
            }
            return tables;
        }
    }

    private class SifterRecipeProvider
    extends CustomRecipeProvider {
        public SifterRecipeProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        @Override
        protected void registerRecipes(@NotNull Consumer<IFinishedRecipe> consumer) {
            for (Map.Entry inputEntry : DefaultSifterCraftingProvider.this.inputs.entrySet()) {
                for (SifterMeshDetails mesh : (List)inputEntry.getValue()) {
                    String name = mesh.getName() + "/" + ((Item)inputEntry.getKey()).getRegistryName().func_110623_a();
                    Stream<Item> loot = mesh.getLootTable().getPools().stream().flatMap(pool -> pool.getEntries().stream()).filter(entry -> entry.getType().equals((Object)EntryTypeEnum.ITEM)).map(entry -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(entry.getName())));
                    CustomRecipeProvider.CustomRecipeBuilder.create(ModJobs.SIFTER_ID.func_110623_a() + "_custom", name).inputs(Stream.of(new ItemStorage(new ItemStack((IItemProvider)inputEntry.getKey())), new ItemStorage(new ItemStack((IItemProvider)mesh.getMesh()), true, false)).collect(Collectors.toList())).secondaryOutputs(Stream.concat(Stream.of(mesh.getMesh()), loot).map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + name)).minBuildingLevel(mesh.getMinBuildingLevel()).build(consumer);
                }
            }
        }
    }

    private static class SifterMeshDetails {
        private final String name;
        private final Item mesh;
        private final int minBuildingLevel;
        private final LootTableJson lootTable;

        public SifterMeshDetails(@NotNull Item mesh, int minBuildingLevel, @NotNull LootTableJson lootTable) {
            this.name = mesh.getRegistryName().func_110623_a().replace("sifter_mesh_", "");
            this.mesh = mesh;
            this.minBuildingLevel = minBuildingLevel;
            this.lootTable = lootTable;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Item getMesh() {
            return this.mesh;
        }

        public int getMinBuildingLevel() {
            return this.minBuildingLevel;
        }

        @NotNull
        public LootTableJson getLootTable() {
            return this.lootTable;
        }
    }
}

